/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于箱体gamma
 *
 * 修改:
 *      类型 : 创建
 *      作者 : 李智明
 *      时间 : 2019.12.17
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported  mc_reset_box_offset */
/* exported  mc_set_send_card_output_image_config */
/* exported  mc_set_hub_card_output_image_config */
/* exported  mc_send_backup_port */

/* global $ */
/* global mc_sdk_param */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    重置箱体偏移信息
 * 参数:
 *    @param {Promise<String>} str_order     指令
 *    @param {Promise<String>} str_memtype     数据类型(固化FLASH , 发送RAM)
 *    @param {Promise<String>} str_cur_ctrl_card     主控芯片名称
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.9.07
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_reset_box_offset(str_order, str_memtype, str_cur_ctrl_card, fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }

    // 获取当前箱体大小
    var str_curr_box_name = parent.SELECT_BOX_NAME;
    var arr_side_box = parent.ARY_SIDE_BOX_DATA;

    var obj_box_wh = {
        str_box_w: "",
        str_box_h: ""
    };


    for (var idx_box = 0; idx_box < arr_side_box.length; idx_box++) {
        var obj_each = arr_side_box[idx_box];

        if (str_curr_box_name === obj_each.name) {
            obj_box_wh.str_box_w = obj_each.width;
            obj_box_wh.str_box_h = obj_each.height;
            break;
        }
    }

    // 用来获取当前发送卡id的信息标识
    var s_id = str_order.split(":")[0];
    // 用于下发的发送id
    var s_id_send = s_id;

    // 特殊处理 发送卡下标 取决外部选中的发送卡 不受load选择影响
    if (-1 === Number(s_id) || !s_id) {
        // s_id = "0";
        s_id = mc_get_top_data("g_obj_sendcard_data").get_current_sendcard_param().toString();
    }

    // 下发主控图像配置 / 主控输出端口配置 / hub卡图像配置 / hub卡端口图像配置 / 接收卡偏移
    mc_s_img_config(function () {
        mc_s_outport_img_config(function () {
            // 检测当前是否存在分控
            var ui_s_p_cnt = obj_hardware.get_port_cnt(s_id);
            var b_exict_hub = false;

            for (var idx = 0; idx < ui_s_p_cnt; idx++) {
                var ui_h = obj_hardware.get_hub_cnt(s_id, idx);

                if (0 < ui_h) {
                    b_exict_hub = true;
                    break;
                }
            }

            // 发送卡所有端口都不存在分控 直接发偏移
            if (!b_exict_hub) {
                mc_init_offset(function (error) {
                    fun_callback(error);
                    return;
                });
                return;
            }

            mc_h_img_config(function () {
                mc_h_outport_img_config(function () {
                    mc_init_offset(function (error) {
                        fun_callback(error);
                    });
                    return;
                });
                return;
            });
            return;
        });
        return;
    });
    return;

    // 下发主控图像配置
    function mc_s_img_config(fun_inset_callback) {
        var str_s_img = "(0:0:" + obj_box_wh.str_box_w + ":" + obj_box_wh.str_box_h + ")";
        var obj_req = new mc_sdk_param();

        obj_req.set_param_clear();
        obj_req.set_cmd("SET_PARAM");
        obj_req.set_func("HW_SENDCARD_IMG_RECT");
        obj_req.set_param_value(s_id_send, str_s_img);
        // obj_req.set_param_value(s_id, str_s_img);
        // obj_req.set_attr_val(s_id, "CHIPNAME", str_cur_ctrl_card);
        // obj_req.set_attr_val(s_id, "MEMTYPE", str_memtype);

        $.post("/access_shell", obj_req.get_json(), function (result, status) {
            fun_inset_callback();
            return;
        });
    }

    // 主控输出端口配置
    function mc_s_outport_img_config(fun_inset_callback) {
        // var str_s_port_page = str_order.split(":")[1];
        var str_s_img = "(0:0:" + obj_box_wh.str_box_w + ":" + obj_box_wh.str_box_h + ")";

        // 获取所有发送卡下最多端口的进行下发 确保所有发送卡端口的重置 (未定暂不添加)

        // 发所有
        // if(Number(str_s_port_page) === -1){
        var ui_s_port_cnt = obj_hardware.get_port_cnt(Number(s_id));
        // }
        var str_all_img = "";

        for (var idx = 0; idx < ui_s_port_cnt; idx++) {
            str_all_img += str_s_img;
            str_all_img += ",";
        }
        str_all_img = str_all_img.slice(0, -1);

        var obj_req = new mc_sdk_param();

        obj_req.set_param_clear();
        obj_req.set_cmd("SET_PARAM");
        obj_req.set_func("HW_SENDCARD_OUTPORT_IMG_RECT");
        obj_req.set_param_value(s_id_send, str_all_img);
        // obj_req.set_param_value(s_id, str_all_img);
        // obj_req.set_attr_val(s_id, "CHIPNAME", str_cur_ctrl_card);
        // obj_req.set_attr_val(s_id, "MEMTYPE", str_memtype);

        $.post("/access_shell", obj_req.get_json(), function (result, status) {
            fun_inset_callback();
            return;
        });
    }

    // hub卡图像配置 暂时写死修改所有分控
    function mc_h_img_config(fun_inset_callback) {
        // var str_key = "(" + str_order.split(":")[0] + ":" + str_order.split(":")[1] + ":" + str_order.split(":")[2] + ")";

        var str_key = "(" + str_order.split(":")[0] + ":-1:-1)";
        var str_h_img = "(0:0:" + obj_box_wh.str_box_w + ":" + obj_box_wh.str_box_h + ")";


        var obj_req = new mc_sdk_param();

        obj_req.set_param_clear();
        obj_req.set_cmd("SET_PARAM");
        obj_req.set_func("HW_HUBCARD_IMG_RECT");
        obj_req.set_param_value(str_key, str_h_img);
        // obj_req.set_attr_val(str_key, "CHIPNAME", str_cur_ctrl_card);
        // obj_req.set_attr_val(str_key, "MEMTYPE", str_memtype);

        $.post("/access_shell", obj_req.get_json(), function (result, status) {
            fun_inset_callback();
            return;
        });
    }

    // hub卡端口图像配置
    function mc_h_outport_img_config(fun_inset_callback) {
        var arr_s_h_img = mc_handle_s_h_cnt();

        // 下发总次数
        var ui_send_cnt = arr_s_h_img.length;
        var ui_cnt = 0;

        mc_send_h_p_outport();

        function mc_send_h_p_outport() {
            if (ui_cnt < ui_send_cnt) {
                // 下发
                var str_id = arr_s_h_img[ui_cnt].id;
                var str_val = arr_s_h_img[ui_cnt].val;
                var obj_req = new mc_sdk_param();

                obj_req.set_param_clear();
                obj_req.set_cmd("SET_PARAM");
                obj_req.set_func("HW_HUBCARD_OUTPORT_IMG_RECT");
                obj_req.set_param_value(str_id, str_val);
                // obj_req.set_attr_val(str_id, "CHIPNAME", str_cur_ctrl_card);
                // obj_req.set_attr_val(str_id, "MEMTYPE", str_memtype);


                $.post("/access_shell", obj_req.get_json(), function (result, status) {
                    ui_cnt += 1;
                    mc_send_h_p_outport();
                    return;
                });
                return;
            }
            fun_inset_callback();
            return;
        }
    }

    // 获取分控下端口数量 用于下发分控输出端口图像配置
    function mc_handle_s_h_cnt() {
        var arr_data_h_p = [];
        var arr_return = [];

        var ui_s_port_cnt = obj_hardware.get_port_cnt(Number(s_id));

        for (var idx_s_p = 0; idx_s_p < ui_s_port_cnt; idx_s_p++) {
            var ui_s_p_hub_cnt = obj_hardware.get_hub_cnt(s_id, idx_s_p);

            for (var idx_h = 0; idx_h < ui_s_p_hub_cnt; idx_h++) {
                var ui_h_p_cnt = obj_hardware.get_hub_prot_cnt(s_id, idx_s_p, idx_h);

                if (0 === ui_h_p_cnt) {
                    continue;
                }
                var obj_item = {
                    id: "",
                    val: "",
                    cnt: ""
                };
                var str_id = "(" + s_id + ":" + idx_s_p + ":" + idx_h + ")";
                var str_each_h_p_item = "(0:0:" + obj_box_wh.str_box_w + ":" + obj_box_wh.str_box_h + ")";
                var str_all_item = "";

                for (var idx_h_p = 0; idx_h_p < ui_h_p_cnt; idx_h_p++) {
                    str_all_item += str_each_h_p_item;
                    str_all_item += ",";
                }
                str_all_item = str_all_item.slice(0, -1);

                obj_item.id = str_id;
                obj_item.val = str_all_item;
                obj_item.cnt = ui_h_p_cnt;

                arr_data_h_p.push(obj_item);
            }
        }

        // 若没有分控
        if (0 === arr_data_h_p.length) {
            return false;
        }

        // 进一步筛选 数量一样直接发全部 要是有不一样就 分开发
        var ui_cnt_h_p = arr_data_h_p.length;
        var b_if_same = true;

        var ui_first_cnt = arr_data_h_p[0].cnt;

        for (var idx_item = 1; idx_item < ui_cnt_h_p; idx_item++) {
            var each_item_cnt = arr_data_h_p[idx_item].cnt;

            if (ui_first_cnt === each_item_cnt) {
                ui_first_cnt = each_item_cnt;
            } else {
                b_if_same = false;
                break;
            }
        }

        if (b_if_same) {
            // 都相同 数量
            arr_return[0] = arr_data_h_p[0];
            arr_return[0].id = "(" + s_id_send + ":-1:-1)";
            // arr_return[0].id = "(" + s_id + ":-1:-1)";
        } else {
            arr_return = arr_data_h_p;
        }

        return arr_return;
    }

    function mc_init_offset(fun_inset_callback) {
        var obj_req = new mc_sdk_param();

        obj_req.set_param_clear();
        obj_req.set_cmd("SET_PARAM");
        obj_req.set_func("HW_BOX_OFFSET");
        obj_req.set_param_value("RECVCARD", str_order);
        obj_req.set_attr_val("RECVCARD", "CMD", "(0:0:0:0)");
        obj_req.set_attr_val("RECVCARD", "CHIPNAME", str_cur_ctrl_card);
        obj_req.set_attr_val("RECVCARD", "MEMTYPE", str_memtype);

        // var str_workmode = "0";

        // if ("RAM" === str_memtype) {
        //     if (parent.b_if_mass) {
        //         str_workmode = "1";
        //     }
        // }
        // if ("FLASH" === str_memtype) {
        //     if (parent.b_if_mass) {
        //         str_workmode = "1";
        //     }
        //     if (parent.b_if_mirror) {
        //         str_workmode = "2";
        //     }
        //     if (parent.b_if_mass && parent.b_if_mirror) {
        //         str_workmode = "3";
        //     }
        // }
        // obj_req.set_attr_val("RECVCARD", "WORKMODE", str_workmode);


        $.post("/access_shell", obj_req.get_json(), function (result, status) {
            // if ("success" !== status) {
            //     fun_callback("");
            //     return;
            // }
            var obk_box_offset_res = new mc_sdk_param();

            obk_box_offset_res.set_json(result);
            var error = obk_box_offset_res.get_param_value("ERROR_CODE");

            // fun_callback(error);
            fun_inset_callback(error);
            return;
        });
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下发发送卡输出端口
 * 参数:
 *    @param {Promise<object>} obj_data     箱体界面含pin值的模组
 *    @param {Promise<String>} str_order     指令
 *    @param {Promise<Number>} ui_send_port_cnt     当前指令下的发送卡端口数量
 *    @param {Promise<String>} str_chip     主控芯片名称
 *    @param {Promise<String>} str_memtype     数据类型(固化FLASH , 发送RAM)
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.12.23
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_set_send_card_output_image_config(obj_data, str_order, ui_send_port_cnt, str_chip, str_memtype, fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }

    var str_send_id = str_order.split(":")[0];
    var str_val = mc_anylsis_WH(obj_data);
    var str_data = "";

    for (var id = 0; id < ui_send_port_cnt; id++) {
        str_data += str_val;
        str_data += ",";
    }
    str_data = str_data.slice(0, -1);
    var obj_box_offset_req = new mc_sdk_param();

    obj_box_offset_req.set_param_clear();
    obj_box_offset_req.set_cmd("SET_PARAM");
    obj_box_offset_req.set_func("HW_SENDCARD_OUTPORT_IMG_RECT");
    obj_box_offset_req.set_param_value(str_send_id, str_data);
    // obj_box_offset_req.set_attr_val(str_send_id, "CHIPNAME", str_chip);
    obj_box_offset_req.set_attr_val(str_send_id, "MEMTYPE", str_memtype);

    $.post("/access_shell", obj_box_offset_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obk_box_offset_res = new mc_sdk_param();

        obk_box_offset_res.set_json(result);
        var error = obk_box_offset_res.get_param_value("ERROR_CODE");

        fun_callback(error);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下发HUB卡输出端口
 * 参数:
 *    @param {Promise<object>} obj_data     箱体界面含pin值的模组
 *    @param {Promise<String>} str_order     指令
 *    @param {Promise<Number>} ui_set_cnt     下发端口图像配置的数量
 *    @param {Promise<String>} str_chip     主控芯片名称
 *    @param {Promise<String>} str_memtype     数据类型(固化FLASH , 发送RAM)
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @param {Promise<String>} error 错误码

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.12.23
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_set_hub_card_output_image_config(obj_data, str_order, ui_set_cnt, str_chip, str_memtype, fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }
    var str_val = mc_anylsis_WH(obj_data);
    var str_data = "";
    var str_set_order = "(" + str_order.split(":")[0] + ":" + str_order.split(":")[1] + ":" + str_order.split(":")[2] + ")";

    for (var id = 0; ui_set_cnt > id; id++) {
        str_data += str_val;
        if (ui_set_cnt - 1 !== id) {
            str_data += ",";
        }
    }
    var obj_box_offset_req = new mc_sdk_param();

    obj_box_offset_req.set_param_clear();
    obj_box_offset_req.set_cmd("SET_PARAM");
    obj_box_offset_req.set_func("HW_HUBCARD_OUTPORT_IMG_RECT");
    obj_box_offset_req.set_param_value(str_set_order, str_data);
    // obj_box_offset_req.set_attr_val(str_set_order, "CHIPNAME", str_chip);
    obj_box_offset_req.set_attr_val(str_set_order, "MEMTYPE", str_memtype);

    $.post("/access_shell", obj_box_offset_req.get_json(), function (result, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        var obk_box_offset_res = new mc_sdk_param();

        obk_box_offset_res.set_json(result);
        var error = obk_box_offset_res.get_param_value("ERROR_CODE");

        fun_callback(error);
        return;
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析箱体图像算宽高表达式
 * 参数:
 *    @param {Promise<object>} obj     箱体界面含pin值的模组

 * 返回：
 *    @param {Promise<String>} str_val 端口图像配置表达式

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2020.12.23
 *      内容 : 所有代码
 ************************************************************************************************/

function mc_anylsis_WH(obj) {
    var min_L = 0;
    var min_T = 0;
    var max_L = 0;
    var max_T = 0;
    var min_L_jungle = 0;
    var min_T_jungle = 0;
    var max_L_jungle = 0;
    var max_T_jungle = 0;
    var str_out_congfig = "0:0:";

    var b_first = true;

    for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
            for (var idx = 0; idx < obj[key].length; idx++) {
                min_L_jungle = Number(obj[key][idx].find(".mod_pot").text().split(",")[0]);
                min_T_jungle = Number(obj[key][idx].find(".mod_pot").text().split(",")[1]);
                max_L_jungle = Number(obj[key][idx].find(".mod_pot").text().split(",")[0]) + Number(obj[key][idx].find(".mod_size").text().split("X")[0]);
                max_T_jungle = Number(obj[key][idx].find(".mod_pot").text().split(",")[1]) + Number(obj[key][idx].find(".mod_size").text().split("X")[1]);

                if (b_first) {
                    max_L = max_L_jungle;
                    max_T = max_T_jungle;
                    min_L = min_L_jungle;
                    min_T = min_T_jungle;
                    b_first = false;
                    continue;
                }
                // L MIN
                if (min_L_jungle < min_L) {
                    min_L = min_L_jungle;
                }
                // T MIN
                if (min_T_jungle < min_T) {
                    min_T = min_T_jungle;
                }
                // L MAX
                if (max_L_jungle > max_L) {
                    max_L = max_L_jungle;
                }
                // T MAX
                if (max_T_jungle > max_T) {
                    max_T = max_T_jungle;
                }
            }
        }
    }
    str_out_congfig += ((max_L - min_L) + ":" + (max_T - min_T));
    str_out_congfig = "(" + str_out_congfig + ")";
    return str_out_congfig;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析当前硬件选择界面字串 检查是否存在接收卡名称
 * 参数:
 *    @param {Promise<object>} str_json     箱体界面含pin值的模组

 * 返回：
 *    @return {Promise<boolean>}  true / false   有接收卡 / 无接收卡

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.04.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_recv_name(str_json) {
    var obj_json = new mc_sdk_param();

    obj_json.set_param_clear();
    obj_json.set_json(str_json);

    // 获取当前所有name
    var arr_all_name = [];

    var ui_length = obj_json.get_param_cnt();

    for (var idx = 0; idx < ui_length; idx++) {
        var str_each_name = obj_json.get_param_name(idx);

        arr_all_name.push(str_each_name);
    }

    var ui_name_length = arr_all_name.length;
    var b_exist = true;

    for (var id = 0; id < ui_name_length; id++) {
        if ("MC_LANG_RECE_CARD_TYPE" === arr_all_name[id]) {
            b_exist = false;
        }
    }
    // 不存在接收卡类型选项
    if (b_exist) {
        return false;
    }

    var str_recv_val = obj_json.get_param_value("MC_LANG_RECE_CARD_TYPE");
    // 判断是否有值

    if (!str_recv_val || "MC_LANG_OPTION_NULL" === str_recv_val) {
        return false;
    }

    return true;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    读写HUB输出口使能
 * 参数:
 *    @param {Promise<string>} str_order     命令
 *    @param {Promise<string>} str_type     下发方式
 *    @param {Promise<Array>} arr_backup_status     当前发送卡下的输出口的备份
 *    @param {Promise<function>} fn_callback     回调
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.05
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_send_backup_port(str_order, str_type, arr_backup_status, fn_callback) {
    if ("MC_LANG_BTN_HW_WRITE" === str_type) {
        str_type = "RAM";
    } else {
        str_type = "FLASH";
    }

    // 指令去前三个
    var arr_order = str_order.split(":");

    var str_s_id = arr_order[0];
    // var str_s_p_id = arr_order[1];
    // var str_h_id = arr_order[2];
    var arr_send_order = [];

    // 先获取发送卡端口
    // 获取发送卡下的端口所有可能存在的hub卡 不区分界面数据
    var ui_s_p_len = arr_backup_status.length;
    // 获取此发送卡下所有端口的hub

    for (var idx = 0; idx < ui_s_p_len; idx++) {
        var str_send_order = str_s_id + ":" + idx;

        arr_send_order.push(str_send_order);
    }
    // 获取hub卡端口数量
    mc_get_hub_p_cnt(arr_send_order, function (obj_data) {
        // 下发备份口
        mc_set_each_backup_port_send(arr_order, str_type, obj_data, arr_backup_status, function (data) {
            fn_callback(data);
            return;
        });
    });
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取hub卡端口数量
 * 参数:
 *    @param {Promise<string>} arr_order     界面所选的指令
 *    @param {Promise<function>} fn_callback     回调

 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.05
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_hub_p_cnt(arr_order, fn_callback) {
    // 请求对象
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("GET_PARAM");
    obj_req.set_func("HW_HUBCARD_CONNECT");
    var ui_order_cnt = arr_order.length;

    for (var idx = 0; idx < ui_order_cnt; idx++) {
        obj_req.set_param_value((idx + ""), arr_order[idx]);
    }

    $.post("/access_shell", obj_req.get_json(), function (result, status) {
        var obj_res = new mc_sdk_param();

        obj_res.set_param_clear();
        obj_res.set_json(result);

        var ui_param_cnt = obj_res.get_param_cnt();
        var obj_h_p_cnt = {};


        for (var id = 0; id < ui_param_cnt; id++) {
            var str_param_name = obj_res.get_param_name(id);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            }
            var str_param_val = obj_res.get_param_value(str_param_name);
            var ui_attr_cnt = obj_res.get_attr_cnt(str_param_name);

            for (let id_attr = 0; id_attr < ui_attr_cnt; id_attr++) {
                var str_attr_name = "STATUS";
                var str_attr_val = obj_res.get_attr_val(str_param_name, str_attr_name);
                // 防止hub串联
                var arr_series_hub = str_attr_val.split(",");
                var ui_serier_len = arr_series_hub.length;
                var arr_series_cnt = [];
                var arr_series_hub_name = [];

                for (var idx_series = 0; idx_series < ui_serier_len; idx_series++) {
                    var str_each_series_hub = arr_series_hub[idx_series];
                    var str_name = str_each_series_hub.split(":")[0];
                    var str_cnt = str_each_series_hub.split(":")[1];

                    arr_series_hub_name.push(str_name);
                    arr_series_cnt.push(str_cnt);
                }
                obj_h_p_cnt[str_param_val] = JSON.parse(JSON.stringify({
                    "cnt": "",
                    "name": ""
                }));
                obj_h_p_cnt[str_param_val].cnt = arr_series_cnt;
                obj_h_p_cnt[str_param_val].name = arr_series_hub_name;
            }
        }
        fn_callback(obj_h_p_cnt);
        return;
    });
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    下发备份口参数
 * 参数:
 *    @param {Promise<string>} arr_order     cmd方式
 *    @param {Promise<string>} str_type     下发方式
 *    @param {Promise<object>} obj_data      port数量 key: 指令  val : 数组 [] 存在多个时 表示串联
 *    @param {Promise<Array>} arr_backup_status       当前发送卡输出端口的备份状态
 *    @param {Promise<function>} fun_callback     回调

 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.06.04
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_set_each_backup_port_send(arr_order, str_type, obj_data, arr_backup_status, fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback(false);
        return;
    }


    // 筛选界面数据 和硬件实际数据
    var arr_result = mc_handle_page_hw_data(arr_order, obj_data);

    // var arr_hub_name = arr_result[2];

    // if (0 === arr_result[0].length) {
    //     fun_callback(false);
    //     return;
    // }

    // 进一步筛选
    var arr_req = mc_backup_port_filter_data(arr_order, str_type, arr_result, arr_backup_status);
    var str_req = arr_req[0];
    var arr_data = arr_req[1];

    if (!str_req) {
        fun_callback(false);
        return;
    }

    $.post("/access_shell", str_req, function (result, status) {
        fun_callback(arr_data);
        return;
    });
}

// 进一步筛选 判断是否可发-1
function mc_backup_port_filter_data(arr_order, str_type, arr_result, arr_backup_status) {
    var ui_cnt = arr_result[0].length;

    // 循环所有 筛选备份或非备份状态 得出需要关闭的所有分控
    for (var idx = 0; idx < ui_cnt; idx++) {
        // 排除发送卡端口下没有hub卡或 下的hub卡没有端口
        if (!arr_result[1][idx] || "[OBJECT NUMBER]" !== Object.prototype.toString.call(arr_result[1][idx]).toLocaleUpperCase()) {
            continue;
        }

        // 获取当前所有数据的端口
        var str_p_idx = arr_result[0][idx];

        str_p_idx = str_p_idx.split(":")[1];

        // 获取当前端口所对应端口的备份状态
        var str_backup_corresponing_status = arr_backup_status[Number(str_p_idx)];

        // 排除获取不到当前端口是主还是备 则默认是主
        if (!str_backup_corresponing_status && "0" !== str_backup_corresponing_status) {
            str_backup_corresponing_status = "1";
        }

        // 判断当前设置的发送
        if (parent.G_B_BACKUP_PORT_SEND) {
            // 发送备份口 关闭其他主口
            if ("0" !== str_backup_corresponing_status) {
                arr_result[1][idx] = mc_handle_port_stop_par(arr_result[1][idx], false);
            }
        } else {
            // 发送主口 关闭备份主口
            if ("1" !== str_backup_corresponing_status) {
                arr_result[1][idx] = mc_handle_port_stop_par(arr_result[1][idx], false);
            }
        }
    }

    // 进一步筛选 若同一个端口下的分控取值未-1  !!!!!暂时这样处理 端口下所有分控开关或关闭
    var arr_finall = [[], [], []];
    var str_prev_s_p = "";
    var arr_handle_order = "";
    var str_hangle_order = "";

    for (var id_fillter_hub = 0; id_fillter_hub < arr_result[0].length; id_fillter_hub++) {
        var str_curr_order = arr_result[0][id_fillter_hub];
        var str_curr_backup_val = arr_result[1][id_fillter_hub];
        // var str_curr_chip = arr_result[2][id_fillter_hub];
        var str_curr_s_p = arr_result[0][id_fillter_hub].split(":")[1];

        // 检测是数值
        if ("[object Number]" === Object.prototype.toString.call(str_curr_backup_val)) {
            arr_finall[0].push(str_curr_order);
            arr_finall[1].push(str_curr_backup_val);
            // arr_finall[2].push(str_curr_chip);
            continue;
        }

        if (0 === id_fillter_hub) {
            arr_handle_order = str_curr_order.split(":");
            str_hangle_order = arr_handle_order[0] + ":" + str_curr_s_p + ":" + "-1";

            arr_finall[0].push(str_hangle_order);
            arr_finall[1].push(str_curr_backup_val);
            // arr_finall[2].push(str_curr_chip);
            str_prev_s_p = str_curr_s_p;
            continue;
        }


        if (str_prev_s_p === str_curr_s_p) {
            continue;
        }
        str_prev_s_p = str_curr_s_p;
        arr_handle_order = str_curr_order.split(":");
        str_hangle_order = arr_handle_order[0] + ":" + str_curr_s_p + ":" + "-1";
        arr_finall[0].push(str_hangle_order);
        arr_finall[1].push(str_curr_backup_val);
        // arr_finall[2].push(str_curr_chip);
    }


    var arr_send_order = arr_finall[0];
    var arr_send_param = arr_finall[1];

    // 判断当前是否存在数据可下发
    var b_send_ok = false;

    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("SET_PARAM");
    obj_req.set_func("HW_HUBCARD_OUTPORT_ENABLE");

    for (var id_order = 0; id_order < arr_send_order.length; id_order++) {
        if (!arr_send_order[id_order] || !arr_send_param[id_order]) {
            continue;
        }
        if ("[OBJECT NUMBER]" === Object.prototype.toString.call(arr_send_param[id_order]).toLocaleUpperCase()) {
            continue;
        }
        // 当前是需要开启的话就不用发
        if (-1 !== arr_send_param[id_order].indexOf("1")) {
            continue;
        }
        b_send_ok = true;
        obj_req.set_param_value(arr_send_order[id_order], arr_send_param[id_order]);
        // obj_req.set_attr_val(arr_send_order[id_order], "CHIPNAME", arr_hub_name[id_order]);
        obj_req.set_attr_val(arr_send_order[id_order], "MEMTYPE", str_type);
    }

    if (b_send_ok) {
        return [obj_req.get_json(), arr_finall];
    }

    return [false, ""];
}

// 处理接口val值的格式
function mc_handle_port_stop_par(ui, b_stop) {
    // 是否开启禁用使能
    var str_mark_backup = b_stop ? "1" : "0";
    var str_val = "(";

    if (-1 === ui) {
        ui = 8;
    }

    for (var id = 0; id < ui; id++) {
        str_val += str_mark_backup;
        str_val += ":";
    }
    str_val = str_val.slice(0, -1);
    str_val += ")";
    return str_val;
}

// 处理硬件和界面显示
function mc_handle_page_hw_data(arr_order, obj_data) {
    // 界面数据
    var str_s_id = arr_order[0];
    var str_s_p_id = arr_order[1];
    var str_h_id = arr_order[2];

    // var ui_page_s = Number(str_s_id);
    var ui_page_h = Number(str_h_id);

    var str_s_p_page = str_s_id + ":" + str_s_p_id;

    // 下发参数id name_id
    var str_name_id = "";
    // 当前指令下出口的数值
    var ui_curr_h_p_cnt = 0;

    var arr_order_each = [];
    var arr_param_each = [];
    var arr_hub_name = [];

    // eslint-disable-next-line guard-for-in
    for (var key in obj_data) {
        var arr_each_hw_hub_p_cnt = obj_data[key].cnt;
        var arr_each_hw_hub_name = obj_data[key].name;

        if ("-1" !== str_s_p_id) {
            // 页面指定发送卡的某个端口 找硬件是否存在
            if (str_s_p_page === key) {
                // hub卡
                if ("-1" === str_h_id) {
                    // 所有hub卡端口
                    for (var idx_one = 0; idx_one < arr_each_hw_hub_p_cnt.length; idx_one++) {
                        if (!arr_each_hw_hub_p_cnt[idx_one] || !arr_each_hw_hub_name[idx_one]) {
                            // 当前端口卡存 主控:主控端口 表示没有卡
                            str_name_id = key;
                            arr_order_each.push(str_name_id);
                            arr_param_each.push(-1);
                            arr_hub_name.push("");
                            continue;
                        }
                        str_name_id = key + ":" + idx_one;
                        arr_order_each.push(str_name_id);
                        ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[idx_one]);
                        arr_param_each.push(ui_curr_h_p_cnt);
                        arr_hub_name.push(arr_each_hw_hub_name[idx_one]);
                    }
                } else {
                    // 指定某长卡
                    if (!arr_each_hw_hub_p_cnt[ui_page_h]) {
                        continue;
                    }

                    str_name_id = key + ":" + ui_page_h;
                    arr_order_each.push(str_name_id);
                    ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[ui_page_h]);
                    arr_param_each.push(ui_curr_h_p_cnt);
                    arr_hub_name.push(arr_each_hw_hub_name[ui_page_h]);
                }
            }
        } else {
            // 所有发送卡端口
            // hub卡
            if ("-1" === str_h_id) {
                // 所有卡
                // 所有hub卡端口
                for (var idx_nd = 0; idx_nd < arr_each_hw_hub_p_cnt.length; idx_nd++) {
                    if (!arr_each_hw_hub_p_cnt[idx_nd] || !arr_each_hw_hub_name[idx_nd]) {
                        // 当前端口卡存 主控:主控端口 表示没有卡
                        str_name_id = key;
                        arr_order_each.push(str_name_id);
                        arr_param_each.push(-1);
                        arr_hub_name.push("");
                        continue;
                    }
                    str_name_id = key + ":" + idx_nd;
                    arr_order_each.push(str_name_id);
                    ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[idx_nd]);
                    arr_param_each.push(ui_curr_h_p_cnt);
                    arr_hub_name.push(arr_each_hw_hub_name[idx_nd]);
                }
            } else {
                // 指定某张hub卡端口
                if (arr_each_hw_hub_p_cnt.length <= ui_page_h) {
                    continue;
                }
                str_name_id = key + ":" + ui_page_h;
                arr_order_each.push(str_name_id);
                ui_curr_h_p_cnt = Number(arr_each_hw_hub_p_cnt[ui_page_h]);
                arr_param_each.push(ui_curr_h_p_cnt);
                arr_hub_name.push(arr_each_hw_hub_name[ui_page_h]);
            }
        }
    }
    return [arr_order_each, arr_param_each, arr_hub_name];
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取发送卡端口 获取发送卡每个端口的备份状态
 * 参数:
 *    @param {Promise<function>} fun_callback     回调

 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_send_p_backup_status(fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }
    var arr_s_p = [];

    // 请求对象
    var obj_req_s_p = new mc_sdk_param();

    obj_req_s_p.set_param_clear();
    obj_req_s_p.set_func("HW_SENDCARD_CONNECT");
    obj_req_s_p.set_cmd("GET_PARAM");

    $.post("/access_shell", obj_req_s_p.get_json(), function (result, status) {
        var obj_res_s_p = new mc_sdk_param();

        obj_res_s_p.set_param_clear();
        obj_res_s_p.set_json(result);

        var ui_param_cnt = obj_res_s_p.get_param_cnt();

        for (var idx = 0; idx < ui_param_cnt; idx++) {
            var str_param_name = obj_res_s_p.get_param_name(idx);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            }
            var str_param_val = obj_res_s_p.get_param_value(str_param_name);
            var str_cnt = str_param_val.split(":")[1];

            arr_s_p.push(str_cnt);
        }

        // var str_s_id = mc_get_top_data("g_obj_sendcard_data").get_current_sendcard_param() + "";
        var ui_s_cnt = arr_s_p.length;
        var obj_req = new mc_sdk_param();

        obj_req.set_param_clear();
        obj_req.set_cmd("GET_PARAM");
        obj_req.set_func("HW_SENDCARD_OUTPORT_BACKUP");

        for (var idx_s = 0; idx_s < ui_s_cnt; idx_s++) {
            var ui_s_p_cnt = Number(arr_s_p[idx_s]);

            for (var id = 0; id < ui_s_p_cnt; id++) {
                var str_data = "(" + idx_s + ":" + id + ")";

                obj_req.set_param_value(str_data, "");
            }
        }


        $.post("/access_shell", obj_req.get_json(), function (backup_result, status) {
            var obj_return = {

            };
            var obj_res = new mc_sdk_param();

            obj_res.set_param_clear();
            obj_res.set_json(backup_result);
            var ui_par_cnt = obj_res.get_param_cnt();

            for (var key = 0; key < ui_par_cnt; key++) {
                var str_par_name = obj_res.get_param_name(key);

                if ("ERROR_CODE" === str_par_name) {
                    continue;
                }
                var str_par_val = obj_res.get_param_value(str_par_name);

                str_par_name = str_par_name.slice(1, -1);

                if (parent.G_B_BACKUP_PORT_SEND) {
                    // 发备口
                    if ("0" === str_par_val) {
                        obj_return[str_par_name] = true;
                    }
                } else {
                    // 发主口
                    if ("1" === str_par_val || !str_par_val) {
                        obj_return[str_par_name] = true;
                    }
                }
            }
            fun_callback(obj_return);
            return;
        });
        return;
    });
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    开启已关闭的状态
 * 参数:
 *    @param {Promise<Array>} arr_data     下发的数据
 *    @param {Promise<string>} type     memory
 *    @param {Promise<function>} fun_callback     回调

 * 返回：
 *    @return {Promise<boolean>} false/true

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_open_all_backup_stauts(arr_data, type, fun_callback) {
    if (!arr_data) {
        fun_callback();
        return false;
    }
    var arr_order = arr_data[0];
    var arr_val = arr_data[1];
    var ui_cnt = arr_order.length;

    if (0 === ui_cnt) {
        fun_callback();
        return false;
    }
    var str_memery = "RAM";

    if ("send" !== type) {
        str_memery = "FLASH";
    }


    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_cmd("SET_PARAM");
    obj_req.set_func("HW_HUBCARD_OUTPORT_ENABLE");
    var b_true = false;

    for (var idx = 0; idx < ui_cnt; idx++) {
        var str_par_name = arr_order[idx];
        var str_val = arr_val[idx];

        if ("[object Number]" === Object.prototype.toString.call(str_val)) {
            continue;
        }

        var ui_port_cnt = str_val.slice(1, -1).split(":").length;

        var str_send_val = "(";

        for (var id = 0; id < ui_port_cnt; id++) {
            str_send_val += "1:";
        }

        str_send_val = str_send_val.slice(0, -1);
        str_send_val += ")";

        b_true = true;

        obj_req.set_param_value(str_par_name, str_send_val);
        obj_req.set_attr_val(str_par_name, "MEMTYPE", str_memery);
    }

    if (b_true) {
        $.post("/access_shell", obj_req.get_json(), function (result, status) {
            fun_callback();
            return true;
        });
    }

    return false;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    去除json串的某个参数 获取新的json串
 * 参数:
 *    @param {Promise<string>} str_json     原串
 *    @param {Promise<string>} str_param_remove     去掉参数
 *    @param {Promise<string>} str_attr_remove     去掉attr

 * 返回：
 *    @return {Promise<boolean>} false/true

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.09.27
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_remove_param(str_json, str_param_remove, str_attr_remove) {
    var obj_old_param = new mc_sdk_param();
    var obj_new_param = new mc_sdk_param();

    if (!obj_old_param.set_json(str_json)) {
        return str_json;
    }

    var ui_param = obj_old_param.get_param_cnt();

    for (var id = 0; id < ui_param; id++) {
        var str_param_name = obj_old_param.get_param_name(id);

        if (str_param_name === str_param_remove) {
            continue;
        }

        var str_param_val = obj_old_param.get_param_value(str_param_name);

        obj_new_param.set_param_value(str_param_name, str_param_val);

        var ui_attr_cnt = obj_old_param.get_attr_cnt(str_param_name);

        for (var key = 0; key < ui_attr_cnt; key++) {
            var str_attr_name = obj_old_param.get_attr_name(str_param_name, key);

            if (str_attr_remove === str_attr_name) {
                continue;
            }
            var str_attr_val = obj_old_param.get_attr_val(str_param_name, str_attr_name);

            obj_new_param.set_attr_val(str_param_name, str_attr_name, str_attr_val);
        }
    }

    return obj_new_param.get_json();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取当前json串的发送卡参数 attr参数
 * 参数:
 *    @param {Promise<string>} str_json     原串
 *    @param {Promise<string>} str_param_remove     去掉参数
 *    @param {Promise<string>} str_attr_remove     去掉attr

 * 返回：
 *    @return {Promise<boolean>} false/true

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.09.27
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_jungle_json_send_ctrl(str_json) {
    var obj_param = new mc_sdk_param();

    if (!obj_param.set_json(str_json)) {
        return false;
    }

    var obj_new_param = new mc_sdk_param();
    var str_param_name = "MC_LANG_BTN_SCREEN_SENDING_CARD";

    var str_send_param_val = obj_param.get_param_value(str_param_name);

    if (!str_send_param_val) {
        return false;
    }

    obj_new_param.set_param_value(str_param_name, str_send_param_val);

    var ui_cnt = obj_param.get_attr_cnt(str_param_name);

    for (var id = 0; id < ui_cnt; id++) {
        var str_attr_name = obj_param.get_attr_name(str_param_name, id);
        var str_attr_val = obj_param.get_attr_val(str_param_name, str_attr_name);

        obj_new_param.set_attr_val(str_param_name, str_attr_name, str_attr_val);
    }

    return obj_new_param.get_json();
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    判断当前是否有发送卡控件参数值
 * 参数:
 *    @param {Promise<string>} str_json     原串

 * 返回：
 *    @return {Promise<boolean>} false/true

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.09.27
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_handle_send_ctrl(str_json) {
    var obj_param = new mc_sdk_param();

    if (!obj_param.set_json(str_json)) {
        return false;
    }

    var str_param_name = "MC_LANG_BTN_SCREEN_SENDING_CARD";
    var str_send_param_val = obj_param.get_param_value(str_param_name);

    if (!str_send_param_val) {
        return false;
    }

    return true;
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    合并两个json串 若两个字串有相同之处 会覆盖
 * 参数:
 *    @param {Promise<string>} str_json1     原串
 *    @param {Promise<string>} str_json2     原串

 * 返回：
 *    @return {Promise<boolean>} false/true

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.09.27
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_merge_send_left(str_json1, str_json2) {
    var obj_old_param = new mc_sdk_param();
    var obj_new_param = new mc_sdk_param();

    var arr = [str_json1, str_json2];

    for (var idx = 0; 2 > idx; idx++) {
        if (!obj_old_param.set_json(arr[idx])) {
            return false;
        }

        var ui_param = obj_old_param.get_param_cnt();

        for (var id = 0; id < ui_param; id++) {
            var str_param_name = obj_old_param.get_param_name(id);
            var str_param_val = obj_old_param.get_param_value(str_param_name);

            obj_new_param.set_param_value(str_param_name, str_param_val);

            var ui_attr_cnt = obj_old_param.get_attr_cnt(str_param_name);

            for (var key = 0; key < ui_attr_cnt; key++) {
                var str_attr_name = obj_old_param.get_attr_name(str_param_name, key);


                var str_attr_val = obj_old_param.get_attr_val(str_param_name, str_attr_name);

                obj_new_param.set_attr_val(str_param_name, str_attr_name, str_attr_val);
            }
        }
    }


    return obj_new_param.get_json();
}
